/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlnk;

final class Region {
    private long start;
    private long end;

    public Region(String start, String end) {
        this(Region.parseAddr(start), Region.parseAddr(end));
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int getSize() {
        return (int)(this.end - this.start + 1L);
    }

    public void reserve(int size) {
        this.start += (long)size;
    }

    public Region split(long addr) {
        Region tail = new Region(addr, this.end);
        this.end = addr - 1L;
        return tail;
    }

    protected Region(long start, long end) {
        this.start = start;
        this.end = end;
    }

    private static long parseAddr(String addr) {
        switch (addr.charAt(0)) {
            case '%': {
                return Long.parseLong(addr.substring(1), 2);
            }
            case '@': {
                return Long.parseLong(addr.substring(1), 8);
            }
            case '$': {
                return Long.parseLong(addr.substring(1), 16);
            }
        }
        return Long.parseLong(addr);
    }
}

